library ieee;
library work;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity main is
  port (SYSTEM_CLOCK : in std_logic;
 	RS232_RX_DATA : in std_logic;
 	RS232_TX_DATA : out std_logic;
	LED_0 : out std_logic;
	LED_1 : out std_logic;
	LED_2 : out std_logic;
	LED_3 : out std_logic;
	SW_0 : in std_logic;
	SW_1 : in std_logic;
	SW_2 : in std_logic;
	SW_3 : in std_logic);
end entity main;

architecture a of main is

  component uart is
    port (in_clk : in std_logic;
	  in_rs232 : in std_logic;
	  out_rs232 : out std_logic;
	  in_data : in std_logic_vector(7 downto 0);
	  in_signal : in std_logic;
	  out_data : out std_logic_vector(7 downto 0);
	  out_signal : out std_logic);
  end component;

  component clkdiv is
    port (in_clk : in std_logic;
	  out_clk : out std_logic);
  end component;

  signal clk50MHz : std_logic;
  signal clk25MHz : std_logic;
  signal clk13MHz : std_logic;
  signal clk6MHz : std_logic;
  signal clk3MHz : std_logic;
  signal clk1562KHz : std_logic;
  signal clk781KHz : std_logic;
  signal clk391KHz : std_logic;
  signal clk195KHz : std_logic;
  signal clk98KHz : std_logic;
  signal clk49KHz : std_logic;

  signal uart_din : std_logic_vector(7 downto 0);	
  signal uart_dout : std_logic_vector(7 downto 0);	
  signal uart_sigin : std_logic;
  signal uart_sigout : std_logic;

begin

  cd1 : clkdiv PORT MAP(SYSTEM_CLOCK,clk50MHz);
  cd2 : clkdiv PORT MAP(clk50MHz,clk25MHz);
  cd3 : clkdiv PORT MAP(clk25MHz,clk13MHz);
  cd4 : clkdiv PORT MAP(clk13MHz,clk6MHz);
  cd5 : clkdiv PORT MAP(clk6MHz,clk3MHz);
  cd6 : clkdiv PORT MAP(clk3MHz,clk1562KHz);
  cd7 : clkdiv PORT MAP(clk1562KHz,clk781KHz);
  cd8 : clkdiv PORT MAP(clk781KHz,clk391KHz);
  cd9 : clkdiv PORT MAP(clk391KHz,clk195KHz);
  cd10 : clkdiv PORT MAP(clk195KHz,clk98KHz);
  cd11 : clkdiv PORT MAP(clk98KHz,clk49KHz);
  u1 : uart PORT MAP(clk49KHz,RS232_RX_DATA,RS232_TX_DATA,uart_din,
		     uart_sigin,uart_dout,uart_sigout);

  process(clk50MHz,clk49KHz) 
  begin
    if (clk49KHz='1' and clk49KHz'event) then
      uart_sigin <= '0';
      uart_din(7 downto 0) <= "00000000";

      if (uart_sigout = '1') then
	case uart_dout is
	  when "00000000" =>
	    LED_0 <= '1';
	  when "00000001" =>
	    LED_0 <= '0';
	  when "00000010" =>
	    LED_1 <= '1';
	  when "00000011" =>
	    LED_1 <= '0';
	  when "00000100" =>
	    LED_2 <= '1';
	  when "00000101" =>
	    LED_2 <= '0';
	  when "00000110" =>
	    LED_3 <= '1';
	  when "00000111" =>
	    LED_3 <= '0';
	  when "00001000" =>
	    uart_sigin <= '1';
	    uart_din(0) <= SW_0;
	  when "00001001" =>
	    uart_sigin <= '1';
	    uart_din(0) <= SW_1;
	  when "00001010" =>
	    uart_sigin <= '1';
	    uart_din(0) <= SW_2;
	  when "00001011" =>
	    uart_sigin <= '1';
	    uart_din(0) <= SW_3;
	  when others => 
	    null;
	end case;
      end if;
    end if;
  end process;
end architecture a;








