library ieee;
library work;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity uart is
  port (in_clk : in std_logic;
 	in_rs232 : in std_logic;
 	out_rs232 : out std_logic;
	in_data : in std_logic_vector(7 downto 0);
	in_signal : in std_logic;
	out_data : out std_logic_vector(7 downto 0);
	out_signal : out std_logic);
end entity uart;

architecture a of uart is
begin
  process(in_clk) 
    variable rx_reg : std_logic_vector(7 downto 0);
    variable rx_stage : integer range 0 to 9 := 0;
    variable rx_countdown : integer range 0 to 244;
    variable tx_reg : std_logic_vector(7 downto 0);
    variable tx_stage : integer range 0 to 10 := 0;
    variable tx_countdown : integer range 0 to 163;

  begin
    if (in_clk='1' and in_clk'event) then
      if ((tx_stage = 0) and (in_signal = '1')) then
	tx_reg := in_data;
	tx_stage := 1;
	tx_countdown := 20;
      end if;
	
      out_signal <= '0';

      case rx_stage is
	when 0 =>
	  if (in_rs232 = '0') then
	    rx_stage := 1;
	    rx_countdown := 30;
	  end if;

	when 9 =>
	  rx_countdown := rx_countdown - 1;
	  if (rx_countdown = 0) then
	    rx_stage := 0;
	    out_data <= rx_reg;
	    out_signal <= '1';
	  end if;

	when others =>
	  rx_countdown := rx_countdown - 1;
	  if (rx_countdown = 0) then
	    rx_reg(rx_stage-1) := in_rs232;
	    rx_countdown := 20;
	    rx_stage := rx_stage + 1;
	  end if;
      end case;

      case tx_stage is
	when 0 =>
	  out_rs232 <= '1';

	when 1 =>
	  out_rs232 <= '0';
	  tx_countdown := tx_countdown - 1;
          if (tx_countdown = 0) then
	    tx_countdown := 20;
	    tx_stage := tx_stage + 1;
          end if;
	
	when 10 =>
	  out_rs232 <= '1';
	  tx_countdown := tx_countdown - 1;
          if (tx_countdown = 0) then
	    tx_stage := 0;
          end if;

	when others =>
	  out_rs232 <= tx_reg(tx_stage-2);
	  tx_countdown := tx_countdown - 1;
	  if (tx_countdown = 0) then
	    tx_countdown := 20;
	    tx_stage := tx_stage + 1;
	  end if;
      end case;
    end if;
  end process;
end architecture a;








