#from machine import Pin, PWM, freq, mem32, mem16, mem8, lightsleep, idle, enable_irq
from machine import freq, idle
import RP2040mem as MEM


#Set system clock to 250 MHz
sysClock = const(250_000_000)
freq(sysClock)

#Test to make sure frequency is stable
print(freq())


# Set GPIO 1-15 low during configuration
MEM.GPIO.setAllPWMsLow()

#Set switching frequency to 150 kHz
switchFreq = 150_000
Tperiod = int(sysClock/switchFreq)

#Setup PWM pairs
#	period, deadtime, and phase are in # of clocks
#	duty is a value between 0 and 1
#	phase cannot go beyond one half period.  For higher phase shifts, swap use of A and B channels
MEM.PWM.setPWMpair(channel=0, period=Tperiod, duty=.5, deadtime=10, phase=0)
MEM.PWM.setPWMpair(channel=1, period=Tperiod, duty=.5, deadtime=10, phase=Tperiod/2)
MEM.PWM.setPWMpair(channel=2, period=Tperiod, duty=.25, deadtime=10, phase=100)

# Turn on all PWMs
MEM.PWM.turnOnAllPWMs()

# Set GPIO 1-15 as PWM outputs
MEM.GPIO.setAllPWMsOUT()

print('done')
idle()

## ADDITIONAL DOCUMENTATION

##  Pinout
##  https://datasheets.raspberrypi.com/pico/Pico-R3-A4-Pinout.pdf

##  Datasheet
##  https://datasheets.raspberrypi.com/rp2040/rp2040-datasheet.pdf
##  Page 236 -- GPIO Function Select 
##  Page 524 -- PWM Channels vs GPIO
##  Page 531 -- PWM Registers

## MicroPython machine
## https://docs.micropython.org/en/latest/library/machine.html

