from machine import mem32
from micropython import const

BASE = const(0x40014000)
CHANNEL = const(0x08)
STATUS = const(0x00)
CTRL = const(0x04)

FUNCSEL_4 = const(0x4) #PWM setting for FUNCSEL bits
OUTOVER_2 = const(0x002<<8) #PWM setting for output low

def setAllPWMsLow():
    #Set all outpus low while configuring
    mem32[BASE + CHANNEL*0 + CTRL] = OUTOVER_2 #pin 0
    mem32[BASE + CHANNEL*1 + CTRL] = OUTOVER_2 #pin 1

    mem32[BASE + CHANNEL*2 + CTRL] = OUTOVER_2 #pin 4
    mem32[BASE + CHANNEL*3 + CTRL] = OUTOVER_2 #pin 5
    mem32[BASE + CHANNEL*4 + CTRL] = OUTOVER_2 #pin 6
    mem32[BASE + CHANNEL*5 + CTRL] = OUTOVER_2 #pin 7

    mem32[BASE + CHANNEL*6 + CTRL] = OUTOVER_2 #pin 9
    mem32[BASE + CHANNEL*7 + CTRL] = OUTOVER_2 #pin 10
    mem32[BASE + CHANNEL*8 + CTRL] = OUTOVER_2 #pin 11
    mem32[BASE + CHANNEL*9 + CTRL] = OUTOVER_2 #pin 12

    mem32[BASE + CHANNEL*10 + CTRL] = OUTOVER_2 #pin 14
    mem32[BASE + CHANNEL*11 + CTRL] = OUTOVER_2 #pin 15
    mem32[BASE + CHANNEL*12 + CTRL] = OUTOVER_2 #pin 16
    mem32[BASE + CHANNEL*13 + CTRL] = OUTOVER_2 #pin 17

    mem32[BASE + CHANNEL*14 + CTRL] = OUTOVER_2 #pin 19
    mem32[BASE + CHANNEL*15 + CTRL] = OUTOVER_2 #pin 20

def setAllPWMsOUT():
    mem32[BASE + CHANNEL*0 + CTRL] = FUNCSEL_4 #pin 0
    mem32[BASE + CHANNEL*1 + CTRL] = FUNCSEL_4 #pin 1

    mem32[BASE + CHANNEL*2 + CTRL] = FUNCSEL_4 #pin 4
    mem32[BASE + CHANNEL*3 + CTRL] = FUNCSEL_4 #pin 5
    mem32[BASE + CHANNEL*4 + CTRL] = FUNCSEL_4 #pin 6
    mem32[BASE + CHANNEL*5 + CTRL] = FUNCSEL_4 #pin 7

    mem32[BASE + CHANNEL*6 + CTRL] = FUNCSEL_4 #pin 9
    mem32[BASE + CHANNEL*7 + CTRL] = FUNCSEL_4 #pin 10
    mem32[BASE + CHANNEL*8 + CTRL] = FUNCSEL_4 #pin 11
    mem32[BASE + CHANNEL*9 + CTRL] = FUNCSEL_4 #pin 12

    mem32[BASE + CHANNEL*10 + CTRL] = FUNCSEL_4 #pin 14
    mem32[BASE + CHANNEL*11 + CTRL] = FUNCSEL_4 #pin 15
    mem32[BASE + CHANNEL*12 + CTRL] = FUNCSEL_4 #pin 16
    mem32[BASE + CHANNEL*13 + CTRL] = FUNCSEL_4 #pin 17

    mem32[BASE + CHANNEL*14 + CTRL] = FUNCSEL_4 #pin 19
    mem32[BASE + CHANNEL*15 + CTRL] = FUNCSEL_4 #pin 20
