from machine import mem32
from micropython import const

BASE = const(0x40050000)
CSR = const(0x00)
DIV = const(0x04)
CTR = const(0x08)
CC = const(0x0C)
TOP = const(0x10)

EN = const(0xA0)

CHANNEL = const(0x14)

CSR_EN = const(0x01)
CSR_PH_CORRECT = const(0x02)
CSR_INVA = const(0x04)
CSR_INVB = const(0x08)
CSR_PH_RET = const(0x40)
CSR_PH_ADV = const(0x80)

def addr(channel, register):
    return BASE + CHANNEL*channel + register

def PWMchannelGPIO(channel, AB):
    return channel*2 + AB

def PWMchannelPin(channel, AB):
    GPIO = PWMchannelGPIO(channel, AB)
    if GPIO < 3:
        return GPIO +1
    if GPIO <6:
        return GPIO + 2
    if GPIO < 10:
        return GPIO + 3
    if GPIO < 14:
        return GPIO + 4
    if GPIO < 16:
        return GPIO + 5
    
def setPWMpair(channel, period, duty, deadtime, phase):
    # Turn off all PWM modules
    mem32[addr(channel=channel, register=EN)] = 0
    
    # Set period
    mem32[addr(channel=channel, register=TOP)] = int(period/2)
    
    # Set to up-down mode
    mem32[addr(channel=channel, register=CSR)] = CSR_PH_CORRECT + CSR_INVB
    
    #Reset counter initial value accorsing to phase
    mem32[addr(channel=channel, register=CTR)] = int(phase)
    
    #Set both A and B outputs
    mem32[addr(channel=channel, register=CC)] = int(period/2*duty - deadtime/2) + (int(period/2*duty + deadtime/2) << 16)
    
    
#     for i in range(int(phase)):
#         mem32[addr(channel=channel, register=CSR)] = mem32[addr(channel=channel, register=CSR)] | CSR_PH_ADV
#         
#         while mem32[addr(channel=channel, register=CSR)] & CSR_PH_ADV > 0:
#             pass

def turnOnAllPWMs():
    mem32[addr(channel=0, register=EN)] = 0x7F
    
        