types = 'linear';
plotcaps = 1;
plot_all_linear_compare = 0;
simulate = 1;

Vg = 100;
Ll = 12.5e-6;
Il0 = 0.5;
Vc0 = 0;
Vout = -Vg;

tstop = .1e-6;
tstep = 5e-11;




%% FDMC2610
Vtest = [-.01 .1 .5 1 2 5 10 15 20 25 30 35 40 50 100 150 200 300];
Ctest = [1000 580 464 385.5 265.9 168.3 125.5 106.7 95.4 87.7 82 77.6 74 70 55 53 51 51]*1e-12;
% vx = 0:1:200;
% Cx = interp1(Vtest,Ctest,vx,types);
% plot(vx,Cx*1e12, ':b','Linewidth',2);
% hold on;


vx = 0.01:.01:Vg+25;
Cx = interp1(Vtest,Ctest,vx,'linear');
if(plotcaps)
    figure(1)
    loglog(vx, smooth(Cx*1e12),'Linewidth',2.5);
    hold on;
    
    xlim([.1 100]);
    ylim([10 1000]);
    xlabel('Voltage on Capacitor [V]');
    ylabel('Capacitance [pF]');
end


range = find(vx < Vg);


%% Charge Related Capacitance
Q = trapz((vx(range)), Cx(range));
Cpqr = Q/Vg;

%% Energy Related Capacitance
E = trapz(vx(range), Cx(range).*abs((vx(range))));
Cper = 2*(E)/Vg^2;

%% Inductor Energy Related Capacitance
E2 = trapz(vx(range), Cx(range).*(Vout - vx(range)));
Cplr = 2*(E2)/Vg^2;

Cav = trapz(vx(range), Cx(range))/Vg;


%% Linear Capacitor for Comparison
Clin = [Cper Cpqr];
vlin = [min(vx)-.1 max(vx)+.1];

%% Run Simulation
if(simulate)
    simout = sim('nonlinearLC_singleDevice_Simple', 'SaveOutput','on','OutputSaveName','yout');
    yout = simout.find('yout');
    tout = simout.find('tout');
end

% Nonlinear
vc_sim = yout(:,1);
il_sim = yout(:,4);
Ct_sim = yout(:,2);
vcdot_sim = yout(:,3);

%linear
vc_sim_lin = yout(:,5);
il_sim_lin = yout(:,8);
Ct_sim_lin = yout(:,6);
vcdot_sim_lin = yout(:,7);


figure(3)
clf;
plot(tout,il_sim)
hold on;
plot(tout,il_sim_lin,'r')

figure(4)
clf;
plot(tout,vc_sim)
hold on;
plot(tout,vc_sim_lin,'r')




