#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <string.h>
#include <sys/time.h>


#define linelen 83
#define codeversion 0
#define endline 99

void sortInts(int*,int);
int stringCompare(char*,char*);
void stringSort(char**,int);

int checkUpdate(void);
int checkKey(int*);
void getKey(void);
void notifyDanny(int*);

void sendDone(int*);
int checkDone(void);

char getCharInSet(char*,int,const char*);
void removeChar(char*,int,char);

int testSortInts(void);
int testStringCompare(void);
int testStringSort(void);


int main(int nargs, char **args)
{
   int keys[2];
   int stringCompareCorrect = 0;
   int stringSortCorrect = 0;
   int sortIntsCorrect = 0;
   char options[4] = {'C','I','S','E'};
   int numOptions = 4;
   if(checkUpdate())
   {
      printf("Update the code and then you may resume the assigment.\n");
      printf("Testing blocked until update\n\n\n");
      return 0;
   }
   if(!checkKey(keys))
   {
      getKey();
      checkKey(keys);
      notifyDanny(keys);
   }

   printf("When all three routines are tested, ");
   printf("Your lab will be complete.\n");
   printf("All routines must be tested in the SAME program run ");
   printf("to finish the lab.\n\n");
   do
   {
      char choice;
      printf("Which routine would you like to test?\n");
      if(!sortIntsCorrect)
         printf("   [I]: sortInts.c\n");
      if(!stringCompareCorrect)
         printf("   [C]: stringCompare.c\n");
      if(!stringSortCorrect)
         printf("   [S]: stringSort.c\n");
      printf("   [E]: exit\n");
      choice = getCharInSet("Which routine to test? ",numOptions,options);
      switch(choice)
      {
         case 'I':
            sortIntsCorrect = testSortInts();
            if(sortIntsCorrect)
            {
               printf("Great job! your function is correct!\n");
               removeChar(options,numOptions,'I');
               numOptions--;
            }
            else
            {
               printf("Keep at it - your function is not correct yet.\n");
            }
            break;
         case 'C':
            stringCompareCorrect = testStringCompare();
            if(stringCompareCorrect)
            {
               printf("Great job! your function is correct!\n");
               removeChar(options,numOptions,'C');
               numOptions--;
            }
            else
            {
               printf("Keep at it - your function is not correct yet.\n");
            }
            break;
         case 'S':
            stringSortCorrect = testStringSort();
            if(stringSortCorrect)
            {
               printf("Great job! your function is correct!\n");
               removeChar(options,numOptions,'S');
               numOptions--;
            }
            else
            {
               printf("Keep at it - your function is not correct yet.\n");
            }
            break;
         case 'E':
            return 0;
      }
   }while (stringCompareCorrect == 0 ||
           stringSortCorrect == 0 ||
           sortIntsCorrect == 0);

   if(!(checkDone())) /*if you've not already submitted */
      sendDone(keys); /* allow student to submit code */


   return 0;
}

int checkUpdate(void)
{
   char cmdstr[200];
   FILE *fp;
   int v;
   char junk[10];
   strcpy(cmdstr,"wget http://homes.sice.indiana.edu/dasmish/");
   strcat(cmdstr,"E111/MishlerReview/needsUpdate.txt 2>.updatechecker.txt");
   strcat(cmdstr,"; rm .updatechecker.txt");
   system(cmdstr);
   fp = fopen("needsUpdate.txt", "r");
   fgets(cmdstr,200,fp);
   sscanf(cmdstr, "%s %d", junk, &v);
   if(v == codeversion)
   {
      system("rm needsUpdate.txt");
      fclose(fp);
      return 0;
   }
   /* else */
   printf("\n\nThe code was updated! You should update this file with:\n");
   printf("\nwget http://homes.sice.indiana.edu/dasmish/E111/MishlerReview");
   printf("/reviewLab.zip\n");
   printf("\nbe sure to remove your old zipfile and");
   printf("back up your progressfirst!\n");
   printf("You have version %d, but version %d was just posted.\n",
           codeversion, v);
   printf("Reason for update:\n");
   fgets(cmdstr,200,fp);
   printf("%s\n",cmdstr);
   fclose(fp);
   system("rm needsUpdate.txt");
   return 1;
}


void sendDone(int*keys)
{

   FILE*fp;
   char userln[800];
   printf("Congratulations on finishing this exercise. You may now submit.\n");
   printf("Every time you run your code but haven't submitted,\n");
   printf("you will see this prompt\n");
   printf("Are you ready to submit your code?\n");
   printf("[Y]es or [N]o: ");
   do
   {
      fgets(userln,800,stdin);
      if(*userln == 'y' || *userln == 'Y')
      {
         ;
      }
      else if(*userln == 'n' || *userln == 'N')
      {
         return;
      }
      else
      {
         printf("Okay, funny guy 'n' or 'y'.\n");
         printf("[Y]es or [N]o: ");
         *userln = '\0';
      }
   } while (!(*userln));

   fp = fopen("done.txt", "w");
   assert(fp);
   fprintf(fp,"Hello, I have successfully completed the E111 cmdlne lab.\n");
   fprintf(fp, "%d %d\n",keys[0],keys[1]);
   fprintf(fp, "Here are my submissions:\n\n");
   fclose(fp);
   system("cat sortInts.c >> done.txt");
   system("cat stringCompare.c >> done.txt");
   system("cat stringSort.c >> done.txt");
   system("mail -s 'E111 Review Lab Complete' dasmish < done.txt");
   printf("Congratulations on completing the assignment!\n");
   printf("'done.txt' has been created and sent to your TA.\n");
   printf("If you delete 'done.txt', a new one will be made and sent\n");
   printf("To your TA the next time you run the program.\n\n");

   printf("If there is still a lot of extra time in lab,\n");
   printf("I'd recommend working with command line and recursion,\n");
   printf("For all students. For honors, I'd also recommend work\n");
   printf("With linked lists. Good luck on your final, and I hope\n");
   printf("You have a great summer!\n\n\n");
   return;
}

/* from 2020 labs */
int checkKey(int*keys)
/* reutrns: 1 if key exists. 0 if not */
/* if key exists, sets int*keys to the key values */
{
   FILE*fp;
   fp = fopen(".key.txt", "r");
   if(!fp)
      return 0;
   /* else fp exists and a key exists */
   fscanf(fp," %d ", keys);
   fscanf(fp," %d ", keys+1);
   fclose(fp);
   return 1;
}


void getKey(void)
{
   struct timeval *vals;
   int succ;
   FILE *fp;
   vals = malloc(sizeof(struct timeval));
   assert(vals);
   succ = gettimeofday(vals,NULL);
   if(succ)
   {
      printf("There was something wrong with getting your key.\n");
      printf("If you see this message then something is wrong with the lab\n");
      printf("Reach out to your TA!\n");
      exit(1);
   }
   fp = fopen(".key.txt","w");
   if(!fp)
   {
      printf("There was something wrong with getting your key.\n");
      exit(1);
   }
   fprintf(fp, "%d %d\n",(int)vals->tv_sec,(int)vals->tv_usec);
   fprintf(fp, "%s%s%s%s",
           "\n\n\n\nYup, same hidden file drill.\n",
           "This is your key for the assignment.\n",
           "It's one way of checking who could be cheating.\n",
           "Please do not modify or remove this file.\n");
   free(vals);
   fclose(fp);
   return;
}


void notifyDanny(int*keys)
{
   FILE*fp;
   printf("First boot detected for this lab. Your keys are %d and %d.\n",
          keys[0],keys[1]);
   printf("An email has been sent to your TA notifying them that you have\n");
   printf("successfully opened this assignment without issue.\n\n\n\n");
   fp = fopen(".tmpkeys.txt", "w");
   assert(fp);
   fprintf(fp, "Hello, I have successfully opened the E111 cmdlne lab.\n");
   fprintf(fp, "%d %d\n",keys[0],keys[1]);
   fclose(fp);
   system("mail -s 'E111 Review Lab Begin' dasmish < .tmpkeys.txt");
   system("rm .tmpkeys.txt -f");
}


int checkDone(void)
/* returns 1 if done.txt or .scooped.txt exists. 0 else */
{
   FILE*fp;
   fp = fopen(".scooped.txt", "r");
   if(fp)
   {
      fclose(fp);
      return 1;
   }
   fp = fopen("done.txt", "r");
   if(fp)
   {
      fclose(fp);
      return 1;
   }
   return 0;
}


/* remember this one? */
char getCharInSet
(
   char *prompt,   /* what should I ask? */
   int N,          /* number of allowable characters to accept */
   const char *L  /* list of characters to accept */
)
{
   char ugc, rc;          /* ugc from the user, rc to return */
   int i, succ = 0;           /* i for for loops, succ for success */
   while (succ == 0)      /* constantly check while we don't have the value */
   {
      rc = ugc = succ = 0;           /* set them all to 0 to be clear */
      printf(prompt);
      ugc = getchar();               /* Grab a single character */
      if (ugc != '\n')               /* Eat up the rest of the characters */
         while(getchar() != '\n');   /* But only if the user didn't input \n */
      for(i = 0; i < N; i++)         /* Check every character in the list */
         if (ugc == L[i] || ugc == L[i] + 32)/* +32 if they enter lowercase */
         {
            rc = L[i];
            succ = 1;                /* We found a character! */
            break;                   /* End the loop */
         }
      if (succ == 0)                 /* If they failed to match a char */
      {
         printf("please choose one of the following: [");
         for(i = 0; i < N; i++)
         {
            printf("%c", L[i]);      /* List each of the characters */
            if (i < N - 1)
               printf("%c", ',');    /* With a comma between them */
         }
         printf("]\n\n");
      }
   }
   return(rc);
}

/* remove a character from an array, effectively shrinking it */
void removeChar(char*list,int len,char target)
{
   int i;
   for(i = 0; i < len; i++)
   {
      if(list[i] == target)
      {
         break;
      }
   }
   for(; i < len-1;i++)
   {
      list[i] = list[i+1];
   }
   return;
}

/* he who seeketh shall findeth */
void correctSortInts(int* array, int len)
{
   int i,j;
   int swap;
   for(j = 0; j < len-1; j++)
   {
      for(i = 0; i < len-1-j; i++)
      {
         if(array[i] > array[i+1])
         {
            swap = array[i+1];
            array[i+1] = array[i];
            array[i] = swap;
         }
      }
   }
   return;
}

int arrayCompare(int *array1, int *array2, int len)
{
   int i;
   for(i = 0; i < len; i++)
   {
      if(array1[i] - array2[i])
      {
         return(array1[i] - array2[i]);
      }
   }
   return 0;
}

void printArray(int *array, int len)
{
   int i;
   for(i = 0; i < len; i++)
   {
      if(!(i % 10))
      {
         printf("\n");
      }
      printf("%-3d    ",array[i]);
   }
   printf("\n");
}

int arraySorted(int *array, int len)
{
   int i;
   for(i = 0; i < len-1; i++)
   {
      if(array[i] > array[i+1])
      {
         return 0;
      }
   }
   return 1;
}

void randomizeArray(int *array, int len)
{
   int i;
   for(i = 0; i < len; i++)
   {
      array[i] = (rand()%198)-99;/* range of [-99,99] */
   }
   return;
}

int testSortInts(void)
{
   int testArrayD[10] = {5,4,3,2,1};
   int testArrayU[10] = {5,4,3,2,1};
   int i;
   printf("Sorting the following array:\n");
   printArray(testArrayU,5);
   printf("...\n");
   sortInts(testArrayU,5);
   correctSortInts(testArrayD,5);
   if(arrayCompare(testArrayU,testArrayD,5))
   {
      printf("Tester error! The sorted array should be:\n");
      printArray(testArrayD,5);
      printf("\n");
      printf("But you sorted as:\n");
      printArray(testArrayU,5);
      printf("\n");
      return 0;
   }
   for(i = 0; i < 10; i++)
   {
      randomizeArray(testArrayD,10);
      printf("Sorting the following array:\n");
      printArray(testArrayD,10);
      printf("...\n");
      sortInts(testArrayD,10);
      if(!arraySorted(testArrayD,10))
      {
         printf("Tester error! You sorted as:\n");
         printArray(testArrayD,10);
         printf("\n");
         printf("But the sorted array should be:\n");
         correctSortInts(testArrayD,10);
         printArray(testArrayD,10);
         printf("\n");
         return 0;
      }
   }
   printf("All tests passed!\n");
   return 1;
}

#if 1
/* yeah, I really just did that. */
int correctStringCompare(char* st1, char* st2)
{
   int i;
   for(i = 0; st1[i] && st2[i]; i++)
   {
      if(st1[i] > st2[i])
      {
         return 1;
      }
      if(st1[i] < st2[i])
      {
         return 0;
      }
   }
   if(!(st1[i]) && st2[i])
   {
      return 0;
   }
   else if(st1[i] && !(st2[i]))
   {
      return 1;
   }
   /* else if(!(st1[i]) && !(st2[i])) */
   else
   {
      return 0;
   }
}
#else
#include <string.h>
/* another clever way to do it. */
int correctStringCompare(char* st1, char* st2)
{
   int result = strcmp(st1,st2);
   if (result>=1)
      return 1;
   else
      return 0;
}
#endif

void generateRandomString(char*template,int len)
{
   int i;
   for(i = 0; i < len-1; i++)
   {
      template[i] = (rand()%94)+33; /* range 33 to 126 */
   }
   template[i] = '\0';
   return;
}

int testStringCompare(void)
{
   int myResult;
   int yourResult;
   char randomString1[8];
   char randomString2[8];
   int i;
   /* random strings */
   for(i = 0; i < 5; i++)
   {
      generateRandomString(randomString1,8);
      generateRandomString(randomString2,8);
      myResult = correctStringCompare(randomString1,randomString2);
      yourResult = stringCompare(randomString1,randomString2);
      printf("Testing with '%s' and '%s' ... \n",randomString1,randomString2);
      if(myResult != yourResult)
      {
         char *gt = ">";
         char *leq = "<=";
         char *res[2];
         res[0] = gt;
         res[0] = leq;
         printf("Tester Error! Our results do not match for these strings!\n");
         printf("You said '%s' %s '%s',\n",
                randomString1,res[yourResult],randomString2);
         printf("But '%s' %s '%s',\n",
                randomString1,res[myResult],randomString2);
         return 0;
      }
   }

   /* same strings */
   for(i = 0; i < 2; i++)
   {
      int j;
      generateRandomString(randomString1,8);
      for(j = 0; randomString1[j]; j++)
      {
         randomString2[j] = randomString1[j];
      }
      randomString2[j] = randomString1[j];

      myResult = correctStringCompare(randomString1,randomString2);
      yourResult = stringCompare(randomString1,randomString2);
      printf("Testing with '%s' and '%s' ... \n",randomString1,randomString2);
      if(myResult != yourResult)
      {
         char *gt = ">";
         char *leq = "<=";
         char *res[2];
         res[0] = gt;
         res[0] = leq;
         printf("Tester Error! Our results do not match for these strings!\n");
         printf("You said '%s' %s '%s',\n",
                randomString1,res[yourResult],randomString2);
         printf("But '%s' %s '%s',\n",
                randomString1,res[myResult],randomString2);
         return 0;
      }
   }
   /* string 1 longer */
   generateRandomString(randomString1,8);
   generateRandomString(randomString2,7);
   myResult = correctStringCompare(randomString1,randomString2);
   yourResult = stringCompare(randomString1,randomString2);
   printf("Testing with '%s' and '%s' ... \n",randomString1,randomString2);
   if(myResult != yourResult)
   {
      char *gt = ">";
      char *leq = "<=";
      char *res[2];
      res[0] = gt;
      res[0] = leq;
      printf("Tester Error! Our results do not match for these strings!\n");
      printf("You said '%s' %s '%s',\n",
             randomString1,res[yourResult],randomString2);
      printf("But '%s' %s '%s',\n",
             randomString1,res[myResult],randomString2);
      return 0;
   }

   /* string 2 longer */
   generateRandomString(randomString1,6);
   generateRandomString(randomString2,7);
   myResult = correctStringCompare(randomString1,randomString2);
   yourResult = stringCompare(randomString1,randomString2);
   printf("Testing with '%s' and '%s' ... \n",randomString1,randomString2);
   if(myResult != yourResult)
   {
      char *gt = ">";
      char *leq = "<=";
      char *res[2];
      res[0] = gt;
      res[0] = leq;
      printf("Tester Error! Our results do not match for these strings!\n");
      printf("You said '%s' %s '%s',\n",
             randomString1,res[yourResult],randomString2);
      printf("But '%s' %s '%s',\n",
             randomString1,res[myResult],randomString2);
      return 0;
   }


   printf("All tests passed!\n");
   return 1;
}

/* Just the same as sorting ints! */
void correctStringSort(char** stringArray, int len)
{
   int i,j;
   char* swap;
   for(j = 0; j < len-1; j++)
   {
      for(i = 0; i < len-1-j; i++)
      {
         if(correctStringCompare(stringArray[i], stringArray[i+1]))
         {
            swap = stringArray[i+1];
            stringArray[i+1] = stringArray[i];
            stringArray[i] = swap;
         }
      }
   }
   return;
}

int stringArrayCompare(char **array1, char **array2, int len)
{
   int i;
   for(i = 0; i < len; i++)
   {
      if(strcmp(array1[i],array2[i]))
      {
         return(strcmp(array1[i],array2[i]));
      }
   }
   return 0;
}

void printStringArray(char **array, int len)
{
   int i;
   for(i = 0; i < len; i++)
   {
      if(!(i % 5))
      {
         printf("\n");
      }
      printf("%-11s   ",array[i]);
   }
   printf("\n");
}

void generateRandomStringArray(char**template,int len,int strlens)
{
   int i,j;
   for(j = 0; j < len; j++)
   {
      template[j] = malloc((strlens+1)*sizeof(char));
      assert(template[j]);
      for(i = 0; i < strlens; i++)
      {
         /*template[j][i] = (rand()%94)+33;*/ /* range 33 to 126 */
         template[j][i] = (rand()%26)+'A'+(rand()%2)*32; /* alphabetical */
      }
      template[j][i] = '\0';
   }
   return;
}

void freeStringArray(char **array, int len)
{
   int i;
   for(i = 0; i < len; i++)
   {
      free(array[i]);
   }
}

int stringArraySorted(char **array, int len)
{
   int i;
   for(i = 0; i < len-1; i++)
   {
      if(correctStringCompare(array[i],array[i+1]))
      {
         return 0;
      }
   }
   return 1;
}

int testStringSort(void)
{
   char *testArrayD[5];
   int i;
   generateRandomStringArray(testArrayD,5,10);

   for(i = 0; i < 7; i++)
   {
      printf("Sorting the following array:\n");
      printStringArray(testArrayD,5);
      printf("...\n");
      stringSort(testArrayD,5);
      if(!(stringArraySorted(testArrayD,5)))
      {
         printf("Tester error! you sorted as:\n");
         printStringArray(testArrayD,5);
         printf("\n");
         printf("But the sorted array should be:\n");
         correctStringSort(testArrayD,5);
         printStringArray(testArrayD,5);
         printf("\n");
         freeStringArray(testArrayD,5);
         return 0;
      }
   }
   printf("All tests passed!\n");
   return 1;
}
